/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/


class NISimpleUI : public Dialog
{
public:
	NISimpleUI() : Dialog(IDD_SIMPLEUI_DIALOG, "NiTest")
	{
	}
	int  	DoModal(HWND hParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = Dialog::DoModal(hParent);
		return nRet;
	}
protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog)
		//ON_OK(OnOK)
		//ON_DESTROY(OnDestroy)
		//ON_SIZE(OnResize)
		ON_ACTIVEX_EVENT(1, IDC_KNOB, OnPointerValueChangedKnob, VTS_CTRL VTS_I4 VTS_PVARIANT)
		ON_ACTIVEX_EVENT(1, IDC_SLIDER, OnPointerValueChangedSlider, VTS_CTRL VTS_I4 VTS_PVARIANT)
		ON_ACTIVEX_EVENT(1, IDC_NUMERIC1, OnValueChangedNumeric1, VTS_CTRL VTS_PVARIANT VTS_PVARIANT VTS_BOOL)
	EVENTS_END
///----------------------------------------------
	
	BOOL OnInitDialog()
	{
		m_Slide 		= GetItem(IDC_SLIDER).GetActiveXControl();
		m_Numeric2		= GetItem(IDC_NUMERIC2).GetActiveXControl();
		m_Knob 			= GetItem(IDC_KNOB).GetActiveXControl();
		return TRUE;
	}
	void OnPointerValueChangedKnob(Control ctrl, long nPointer, _VARIANT& var) 
	{
		m_Slide.Value = var;
	}

	void OnPointerValueChangedSlider(Control ctrl, long nPointer, _VARIANT& var) 
	{
		m_Numeric2.Value= var;
	}
	// when Numeric1 is changed, then all others will update accordingly
	void OnValueChangedNumeric1(Control ctrl, _VARIANT& varNew, _VARIANT& varOld, BOOL OutOfRange) 
	{
		out_double("new =", varNew);
		out_double("old =", varOld);
		m_Knob.Value= varNew;
	}
	
private:
	Object m_Slide;
	Object m_Numeric2;
	Object m_Knob;
};
